﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using System.Management;

namespace OposSample_CSharp
{
    public partial class FrmMain : Form
    {
        List<string> arrv = new List<string>();

        public FrmMain()
        {
            InitializeComponent();

            Init();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            const int OPOS_SUCCESS = 0;
            if (comboBox1.SelectedItem == null)
            {
                MessageBox.Show("Please select printer.");
            }
            else if ((comboBox2.SelectedItem == null))
            {
                MessageBox.Show("Please select cash drawer.");
            }
            else
            {
                int result = OPOS_SUCCESS;
                string strPrinter = comboBox1.SelectedItem.ToString();
                string strCashDrawer = comboBox2.SelectedItem.ToString();
                FuncTest test = new FuncTest(strPrinter, strCashDrawer, out result);
                if (result == OPOS_SUCCESS)
                {
                    this.Hide();
                    test.ShowDialog(this);
                }
            }
        }

        private void Init()
        {
            try
            {
                RegistryKey hkml = Registry.LocalMachine;
                RegistryKey printer = hkml.OpenSubKey("SOFTWARE\\OLEforRetail\\ServiceOPOS\\POSPrinter");
                string[] arryp = printer.GetValueNames();
                
                foreach (string p in arryp)
                {
                    string v = (string)printer.GetValue(p);
                    arrv.Add(v);
                    comboBox1.Items.Add(p);
                }
                
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message.ToString());
            }
        }

        public static string Distinguish64or32System()
        {
            try
            {
                string addressWidth = String.Empty;
                ConnectionOptions mConnOption = new ConnectionOptions();
                ManagementScope mMs = new ManagementScope("\\\\localhost", mConnOption);
                ObjectQuery mQuery = new ObjectQuery("select AddressWidth from Win32_Processor");
                ManagementObjectSearcher mSearcher = new ManagementObjectSearcher(mMs, mQuery);
                ManagementObjectCollection mObjectCollection = mSearcher.Get();
                foreach (ManagementObject mObject in mObjectCollection)
                {
                    addressWidth = mObject["AddressWidth"].ToString();
                }
                return addressWidth;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return String.Empty;
            }
        }

        private void comboBox1_TextChanged(object sender, EventArgs e)
        {
            RegistryKey hkml = Registry.LocalMachine;

            RegistryKey cashdrawer = hkml.OpenSubKey("SOFTWARE\\OLEforRetail\\ServiceOPOS\\CashDrawer");
            string[] arryc = cashdrawer.GetValueNames();

            comboBox2.Items.Clear();

            foreach (string c in arryc)
            {
                string v = (string)cashdrawer.GetValue(c);
                if (v.Contains(arrv[comboBox1.SelectedIndex]))
                    comboBox2.Items.Add(c);
            }
        }
    }
}
